
<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: index.php");
    exit();
}

// Connect to the database
$host = 'localhost'; // Replace with your DB host
$dbname = 'u627005231_finalKaia'; // Replace with your database name
$user = 'u627005231_finalKaiauser'; // Replace with your DB username
$pass = 'qA3kLmqNS!7'; // Replace with your DB password



try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error connecting to database: " . $e->getMessage());
}

// Update the is_active field if action is triggered
$message = '';
if (isset($_POST['deactivate'])) {
    $businessId = $_POST['business_id'];
    $stmt = $pdo->prepare("UPDATE business SET is_active = 0 WHERE id = :id");
    $stmt->execute(['id' => $businessId]);
    $message = "Business ID $businessId no longer has access.";
}

if (isset($_POST['activate'])) {
    $businessId = $_POST['business_id'];
    $stmt = $pdo->prepare("UPDATE business SET is_active = 1 WHERE id = :id");
    $stmt->execute(['id' => $businessId]);
    $message = "Business ID $businessId has been reactivated.";
}

if (isset($_POST['extend'])) {
    $businessId = $_POST['business_id'];
    $stmt = $pdo->prepare("UPDATE business SET is_active = 1 WHERE id = :id");
    $stmt->execute(['id' => $businessId]);
    $message = "Business ID $businessId has been extended and reactivated.";
}

// Fetch all businesses
$stmt = $pdo->query("SELECT id, name, is_active FROM business");
$businesses = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f8f8;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            max-width: 1200px;
            margin: auto;
            padding: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: center;
        }
        th {
            background-color: #4CAF50;
            color: white;
        }
        input[type="submit"] {
            background-color: #4CAF50;
            color: white;
            padding: 5px 10px;
            border: none;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #45a049;
        }
        h2 {
            text-align: center;
            margin-top: 20px;
        }
        .logout {
            text-align: right;
            margin-bottom: 10px;
        }
        .logout a {
            text-decoration: none;
            color: #4CAF50;
            font-weight: bold;
        }
        .logout a:hover {
            color: #45a049;
        }
    </style>
    <script>
        <?php if ($message): ?>
            alert('<?php echo $message; ?>');
        <?php endif; ?>
    </script>
</head>
<body>
    <div class="container">
        <div class="logout">
            <a href="index.php?logout=true">Logout</a>
        </div>
        <h2>Business Dashboard</h2>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Business Name</th>
                    <th>Is Active</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($businesses as $business): ?>
                    <tr>
                        <td><?php echo $business['id']; ?></td>
                        <td><?php echo $business['name']; ?></td>
                        <td><?php echo $business['is_active'] ? 'Yes' : 'No'; ?></td>
                        <td>
                            <?php if ($business['is_active']): ?>
                                <form method="post" action="">
                                    <input type="hidden" name="business_id" value="<?php echo $business['id']; ?>">
                                    <input type="submit" name="deactivate" value="Deactivate">
                                </form>
                            <?php else: ?>
                                <form method="post" action="">
                                    <input type="hidden" name="business_id" value="<?php echo $business['id']; ?>">
                                    <input type="submit" name="activate" value="Activate">
                                    <input type="submit" name="extend" value="Extend">
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>

