
<?php $__env->startSection('title', __('Attendances')); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Attendance
        <small>List of Attendances</small>
    </h1>

    <form method="GET" action="<?php echo e(route('attendances.index'), false); ?>" class="form-inline">
        <div class="form-group mb-2">
            <label for="start_date" class="sr-only">Start Date</label>
            <input type="date" name="start_date" id="start_date" class="form-control" placeholder="Start Date" value="<?php echo e(request('start_date'), false); ?>">
        </div>
        <div class="form-group mx-sm-3 mb-2">
            <label for="end_date" class="sr-only">End Date</label>
            <input type="date" name="end_date" id="end_date" class="form-control" placeholder="End Date" value="<?php echo e(request('end_date'), false); ?>">
        </div>
        <button type="submit" class="btn btn-primary mb-2">Filter</button>
        <a href="<?php echo e(route('attendance.export', ['start_date' => request('start_date'), 'end_date' => request('end_date')]), false); ?>" class="btn btn-success mb-2">Export to Excel</a>
    </form>
</section>

<!-- Main content -->
<section class="content">

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'Attendances' )]); ?>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Time In</th>
                                    <th>Time Out</th>
                                    <th>Date</th>
                                    <th>Business</th>
                                    <th>Business Location</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($attendance->user->user_full_name, false); ?></td>
                                        <td><?php echo e($attendance->time_in->timezone('Asia/Manila')->format('h:i A'), false); ?></td>
                                        <td><?php echo e($attendance->time_out->timezone('Asia/Manila')->format('h:i A'), false); ?></td>
                                        <td><?php echo e($attendance->created_at->timezone('Asia/Manila')->format('Y-m-d'), false); ?></td>
                                        <td><?php echo e($attendance->business->name, false); ?></td>
                                        <td><?php echo e($attendance->business_location->name, false); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->renderComponent(); ?>

  
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\pos\resources\views/attendance/index.blade.php ENDPATH**/ ?>