<?php

namespace App\Exports;

use App\Attendance;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AttendanceExport implements FromCollection, WithHeadings
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate = null, $endDate = null)
    {
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function collection()
    {
        $query = Attendance::with('user', 'business', 'business_location');

        if ($this->startDate && $this->endDate) {
            $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        }

        return $query->get()->map(function ($attendance) {
            return [
                $attendance->user->user_full_name,
                $attendance->time_in->format('h:i A'),
                $attendance->time_out->format('h:i A'),
                $attendance->created_at->format('Y-m-d'),
                $attendance->business->name,
                $attendance->business_location->name,
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Name',
            'Time In',
            'Time Out',
            'Date',
            'Business',
            'Business Location',
        ];
    }
}
